/* BOLT Forms - Form Definitions */

#include "..\DB\BOLTdb.h"	// Added by ClassView
#include "ctrl/BOLTControls.h"
#include "wx/memory.h"
//class BOLTPage;
 
class BOLTPage : public wxScrolledWindow 
{
	DECLARE_DYNAMIC_CLASS(BOLTPage)
public :
	RECORD_ID GetRecordId();
	RECORD_ID GetClassId();
	bool created;
	void OnKeyUp(wxKeyEvent & event);
	virtual void OnChar(wxKeyEvent& event);
	wxString idStr;
	BOLTPage(wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = /*wxTAB_TRAVERSAL|*/wxWANTS_CHARS|wxCLIP_CHILDREN, const wxString& name = "panel")
		: wxScrolledWindow(parent,id,pos,size,style,name)
	{
		SetFont(parent->GetFont());
		FitInside();
		SetScrollRate(25,25);
		closing=false;
	};
	BOLTPage()
		: wxScrolledWindow(wxGetApp().frame->nbWin,-1,wxDefaultPosition,wxDefaultSize,wxWANTS_CHARS|wxCLIP_CHILDREN,"panel")
	{
		SetFont(wxGetApp().frame->nbWin->GetFont());
		FitInside();
		SetScrollRate(25,25);
		closing=false;
	};
	~BOLTPage() { 
	closing=true;
	};
	void OnText(wxCommandEvent& evt);
	wxString GetID() { return idStr; };
	void SetID(wxString id) { idStr = id; }
	virtual void Refresh();

	int index;
	bool Close(bool force=false);
	bool closing;
	virtual void Dump(ostream& stream) 
	{	stream << "Dump : BOLTPage"; }

private:


	DECLARE_EVENT_TABLE()
};

#define BOLT_NOTEBOOK(p)	wxNotebook(p,ID_BOLT_NOTEBOOK,wxDefaultPosition,wxDefaultSize,wxNB_BOTTOM|wxCLIP_CHILDREN|wxTAB_TRAVERSAL,"Bolt Pages")
#define BOLT_FORM_HOME(p,d)	new bfHome(p,d)
#define BOLT_FORM_ACCOUNTS(p,d,r)	new bfAccount(p,d,r)
#define BOLT_FORM_TRANSACTIONS(p,d,r)	new bfTransaction(p,d,r)
#define BOLT_FORM_ITEMS(p,d,r)	new bfItem(p,d,r)
#define BOLT_FORM_SETTINGS(p,d,r)	new bfSettings(p,d,r)
#define BOLT_FORM_REPORTS(p,d,r)	new bfReport(p,d,r)
#define BOLT_FORM_REGISTER(p,d,r)	new bfRegister(p,d,r)
#define BOLT_FORM_MULTIPAY(p,d,r)	new bfMultipay(p,d,r)

#define TBL_ACCOUNTS	"accounts"
#define TBL_MULTIPAY	"multipaytranactions"
#define TBL_TRANSACTIONS "transactions"
#define TBL_ITEMS		"items"
#define TBL_SETTINGS	"settings"
#define TBL_REPORTS		"reports"
#define TBL_REGISTER	"registers"